
library(memisc)


library(mclogit)


load("model-churchat-cathprot-relprin-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_relprin <- mtable(model_relprin,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "Religious Principles" = c("Squared" = "religious_principles.sq",                        
                                                "Linear"  = "religious_principles",                           
                                                "$\\times$ attends rarely"      = "religious_principles:relattRarely",
                                                "$\\times$ attends on holidays" = "religious_principles:relattHolidays",
                                                "$\\times$ attends monthly"     = "religious_principles:relattMonthly",
                                                "$\\times$ attends weely"       = "religious_principles:relattWeekly",
                                                "$\\times$ Protestant"          = "religious_principles:cathprotProtestant",
                                                "$\\times$ attends rarely      $\\times$ Protestant"      = "religious_principles:relattRarely:cathprotProtestant",
                                                "$\\times$ attends on holidays $\\times$ Protestant"      = "religious_principles:relattHolidays:cathprotProtestant",
                                                "$\\times$ attends monthly     $\\times$ Protestant"      = "religious_principles:relattMonthly:cathprotProtestant",
                                                "$\\times$ attends weely       $\\times$ Protestant"      = "religious_principles:relattWeekly:cathprotProtestant",
                                                "$\\times$ self-employed"  = "religious_principles:oesch8Self-employed",       
                                                "$\\times$ technical"      = "religious_principles:oesch8Technical",           
                                                "$\\times$ management"     = "religious_principles:oesch8Management",          
                                                "$\\times$ clerks"         = "religious_principles:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "religious_principles:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "religious_principles:oesch8Service worker",      
                                                "$\\times$ primary sector" = "religious_principles:oesch8Primary sector",      
                                                "$\\times$ secularized"                  = "religious_principles:No_religion",
                                                "$\\times$ denominational balance"       = "religious_principles:Cath_Prot",
                                                "$\\times$ denominational heterogeneity" = "religious_principles:Denom_Het",
                                                "$\\times$ time" = "religious_principles:time", 
                                                "$\\times$ attends rarely      $\\times$ time"  = "religious_principles:relattRarely:time",
                                                "$\\times$ attends on holidays $\\times$ time"  = "religious_principles:relattHolidays:time",
                                                "$\\times$ attends weekly      $\\times$ time"  = "religious_principles:relattMonthly:time",
                                                "$\\times$ attends daily       $\\times$ time"  = "religious_principles:relattWeekly:time",
                                                "$\\times$ Protestant     $\\times$ time"  = "religious_principles:cathprotProtestant:time",
                                                "$\\times$ attends rarely      $\\times$ Protestant $\\times$ time"  = "religious_principles:relattRarely:cathprotProtestant:time",
                                                "$\\times$ attends on holidays $\\times$ Protestant $\\times$ time"  = "religious_principles:relattHolidays:cathprotProtestant:time",
                                                "$\\times$ attends monthly     $\\times$ Protestant $\\times$ time"  = "religious_principles:relattMonthly:cathprotProtestant:time",
                                                "$\\times$ attends weely       $\\times$ Protestant $\\times$ time"  = "religious_principles:relattWeekly:cathprotProtestant:time",
                                                "$\\times$ self-employed  $\\times$ time"  = "religious_principles:oesch8Self-employed:time",  
                                                "$\\times$ technical      $\\times$ time"  = "religious_principles:oesch8Technical:time",      
                                                "$\\times$ management     $\\times$ time"  = "religious_principles:oesch8Management:time",     
                                                "$\\times$ clerks         $\\times$ time"  = "religious_principles:oesch8Clerks:time",         
                                                "$\\times$ socio-cultural $\\times$ time"  = "religious_principles:oesch8Socio-cultural:time", 
                                                "$\\times$ service worker $\\times$ time"  = "religious_principles:oesch8Service worker:time", 
                                                "$\\times$ primary sector $\\times$ time"  = "religious_principles:oesch8Primary sector:time"),                                  
                            "Immigration" = c("Squared" = "immigration.sq",                                 
                                              "Linear"  = "immigration",               
                                              "$\\times$ attends rarely"      = "relattRarely:immigration",
                                              "$\\times$ attends on holidays" = "relattHolidays:immigration",
                                              "$\\times$ attends monthly"     = "relattMonthly:immigration",
                                              "$\\times$ attends weely"       = "relattWeekly:immigration",
                                              "$\\times$ Protestant"          = "cathprotProtestant:immigration",
                                              "$\\times$ self-employed"  = "oesch8Self-employed:immigration",       
                                              "$\\times$ technical"      = "oesch8Technical:immigration",           
                                              "$\\times$ management"     = "oesch8Management:immigration",          
                                              "$\\times$ clerks"         = "oesch8Clerks:immigration",              
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:immigration",      
                                              "$\\times$ service worker" = "oesch8Service worker:immigration",      
                                              "$\\times$ primary sector" = "oesch8Primary sector:immigration",      
                                              "$\\times$ time" = "time:immigration", 
                                              "$\\times$ attends rarely      $\\times$ time"  = "relattRarely:time:immigration",
                                              "$\\times$ attends on holidays $\\times$ time"  = "relattHolidays:time:immigration",
                                              "$\\times$ attends weekly      $\\times$ time"  = "relattMonthly:time:immigration",
                                              "$\\times$ attends daily       $\\times$ time"  = "relattWeekly:time:immigration",
                                              "$\\times$ Protestant     $\\times$ time"  = "cathprotProtestant:time:immigration",
                                              "$\\times$ self-employed  $\\times$ time"  = "oesch8Self-employed:time:immigration",  
                                              "$\\times$ technical      $\\times$ time"  = "oesch8Technical:time:immigration",      
                                              "$\\times$ management     $\\times$ time"  = "oesch8Management:time:immigration",     
                                              "$\\times$ clerks         $\\times$ time"  = "oesch8Clerks:time:immigration",         
                                              "$\\times$ socio-cultural $\\times$ time"  = "oesch8Socio-cultural:time:immigration", 
                                              "$\\times$ service worker $\\times$ time"  = "oesch8Service worker:time:immigration", 
                                              "$\\times$ primary sector $\\times$ time"  = "oesch8Primary sector:time:immigration"),   
                            "Econ Left--Right"= c("Squared" = "lrecon.sq",
                                              "Linear"  = "lrecon",
                                              "$\\times$ attends rarely"      = "relattRarely:lrecon",
                                              "$\\times$ attends on holidays" = "relattHolidays:lrecon",
                                              "$\\times$ attends monthly"     = "relattMonthly:lrecon",
                                              "$\\times$ attends weely"       = "relattWeekly:lrecon",
                                              "$\\times$ Protestant"          = "cathprotProtestant:lrecon",
                                              "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",       
                                              "$\\times$ technical"      = "oesch8Technical:lrecon",           
                                              "$\\times$ management"     = "oesch8Management:lrecon",          
                                              "$\\times$ clerks"         = "oesch8Clerks:lrecon",              
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",      
                                              "$\\times$ service worker" = "oesch8Service worker:lrecon",      
                                              "$\\times$ primary sector" = "oesch8Primary sector:lrecon",      
                                              "$\\times$ time" = "time:lrecon", 
                                              "$\\times$ attends rarely      $\\times$ time"  = "relattRarely:time:lrecon",
                                              "$\\times$ attends on holidays $\\times$ time"  = "relattHolidays:time:lrecon",
                                              "$\\times$ attends weekly      $\\times$ time"  = "relattMonthly:time:lrecon",
                                              "$\\times$ attends daily       $\\times$ time"  = "relattWeekly:time:lrecon",
                                              "$\\times$ Protestant     $\\times$ time"  = "cathprotProtestant:time:lrecon",
                                              "$\\times$ self-employed  $\\times$ time"  = "oesch8Self-employed:time:lrecon",  
                                              "$\\times$ technical      $\\times$ time"  = "oesch8Technical:time:lrecon",      
                                              "$\\times$ management     $\\times$ time"  = "oesch8Management:time:lrecon",     
                                              "$\\times$ clerks         $\\times$ time"  = "oesch8Clerks:time:lrecon",         
                                              "$\\times$ socio-cultural $\\times$ time"  = "oesch8Socio-cultural:time:lrecon", 
                                              "$\\times$ service worker $\\times$ time"  = "oesch8Service worker:time:lrecon", 
                                              "$\\times$ primary sector $\\times$ time"  = "oesch8Primary sector:time:lrecon")
                        )))


m_relprin


m_relprin |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="churchat-context-relprin/mtable-churchat-cathprot-context-relprin.tex")




